/*! firebase-admin v10.3.0 */
/*!
 * @license
 * Copyright 2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Interface representing task options with delayed delivery.
 */
export interface DelayDelivery {
    /**
     * The duration of delay of the time when the task is scheduled to be attempted or retried.
     * This delay is added to the current time.
     */
    scheduleDelaySeconds?: number;
    /** @alpha */
    scheduleTime?: never;
}
/**
 * Interface representing task options with absolute delivery.
 */
export interface AbsoluteDelivery {
    /**
     * The time when the task is scheduled to be attempted or retried.
     */
    scheduleTime?: Date;
    /** @alpha */
    scheduleDelaySeconds?: never;
}
/**
 * Type representing delivery schedule options.
 * `DeliverySchedule` is a union type of {@link DelayDelivery} and {@link AbsoluteDelivery} types.
 */
export declare type DeliverySchedule = DelayDelivery | AbsoluteDelivery;
/**
 * Type representing task options.
 */
export declare type TaskOptions = DeliverySchedule & TaskOptionsExperimental & {
    /**
     * The deadline for requests sent to the worker. If the worker does not respond by this deadline
     * then the request is cancelled and the attempt is marked as a DEADLINE_EXCEEDED failure.
     * Cloud Tasks will retry the task according to the `RetryConfig`.
     * The default is 10 minutes. The deadline must be in the range of 15 seconds and 30 minutes.
     */
    dispatchDeadlineSeconds?: number;
};
/**
 * Type representing experimental (beta) task options.
 */
export interface TaskOptionsExperimental {
    /**
   * The full URL path that the request will be sent to. Must be a valid URL.
   * @beta
   */
    uri?: string;
}
